﻿using System;
using System.IO;
using System.Net;
using System.Text;
using VA.PPMS.CRM.Plugins.Data;

namespace VA.PPMS.CRM.Plugins.Helper
{
    public class SharePointHelper
    {
        public static string GetTenantId(string sharepointSiteToPing)
        {
            string tenantId = string.Empty;
            WebRequest request = WebRequest.Create(sharepointSiteToPing);
            request.Headers.Add("Authorization: Bearer ");

            try
            {
                using (request.GetResponse())
                { }
            }
            catch (WebException e)
            {
                string bearerResponseHeader = e.Response.Headers["WWW-Authenticate"];
                const string bearer = "Bearer realm=\"";
                int bearerIndex = bearerResponseHeader.IndexOf(bearer, StringComparison.Ordinal);
                int realmIndex = bearerIndex + bearer.Length;
                string resource = string.Empty;

                if (bearerResponseHeader.Length >= realmIndex + 36)
                {
                    tenantId = bearerResponseHeader.Substring(realmIndex, 36);

                    // Validate tenantId is a Guid
                    if (Guid.TryParse(tenantId, out Guid realmGuid))
                    { }
                }

                const string client = "client_id=\"";
                int clientIndex = bearerResponseHeader.IndexOf(client, StringComparison.Ordinal);
                int clientIdIndex = clientIndex + client.Length;

                if (bearerResponseHeader.Length >= clientIdIndex + 36)
                {
                    resource = bearerResponseHeader.Substring(clientIdIndex, 36);

                    // Validate resource is a Guid
                    if (Guid.TryParse(resource, out Guid resourceGuid))
                    { }
                }
            }
            catch (Exception)
            {
                throw;
            }

            return tenantId;
        }

        public static string GetAuthorisationToken(string sharepointDomain, string tenantId, string resource, string clientId, string clientSecret)
        {
            string access_token = string.Empty;
            var tenantGuid = ToGuid(tenantId);
            WebRequest request = WebRequest.Create($"https://accounts.accesscontrol.windows.net/{tenantGuid.ToString()}/tokens/OAuth/2");
            request.Method = "POST";

            var urlTenantId = WebUtility.UrlEncode($"{clientId}@{tenantId}");
            var urlClientSecret = WebUtility.UrlEncode(clientSecret);
            var urlResource = WebUtility.UrlEncode($"{resource}/{sharepointDomain}@{tenantId}");

            // Create POST data and convert it to a byte array. 
            string postData = $"grant_type=client_credentials&client_id={urlTenantId}&client_secret={urlClientSecret}&resource={urlResource}";

            byte[] byteArray = Encoding.UTF8.GetBytes(postData);

            // Set the ContentType property of the WebRequest. 
            request.ContentType = "application/x-www-form-urlencoded";

            // Set the ContentLength property of the WebRequest. 
            request.ContentLength = byteArray.Length;

            // Get the request stream. 
            Stream dataStream = request.GetRequestStream();

            // Write the data to the request stream. 
            dataStream.Write(byteArray, 0, byteArray.Length);

            // Close the Stream object. 
            dataStream.Close();

            try
            {
                using (WebResponse response = request.GetResponse())
                {
                    // Display the status. 
                    Console.WriteLine($"Status of Token Request: {((HttpWebResponse)response).StatusDescription}");

                    // Get the stream containing content returned by the server. 
                    dataStream = response.GetResponseStream();

                    // Open the stream using a StreamReader for easy access. 
                    StreamReader reader = new StreamReader(dataStream);

                    // Read the content. 
                    string responseFromServer = reader.ReadToEnd();

                    // Clean up the streams. 
                    reader.Close();
                    dataStream.Close();

                    //Get accesss token
                    const string accessToken = "access_token\":\"";
                    int clientIndex = responseFromServer.IndexOf(accessToken, StringComparison.Ordinal);
                    int accessTokenIndex = clientIndex + accessToken.Length;

                    access_token = responseFromServer.Substring(accessTokenIndex, (responseFromServer.Length - accessTokenIndex - 2));

                    return access_token;
                }
            }
            catch (WebException wex)
            {
                HttpWebResponse httpResponse = wex.Response as HttpWebResponse;
                // resource was not modified.
                Console.WriteLine($"Access token not retrieved: {httpResponse.StatusDescription}");

                // Something else happened. Rethrow or log.
                throw;
            }
            catch (Exception)
            {
                // Something else happened. Rethrow or log.
                throw;
            }
        }

        private static Guid ToGuid(string guid)
        {
            if (Guid.TryParse(guid, out Guid guidOut))
            {
                return guidOut;
            }
            else
            {
                throw new ArgumentException("Guid value is invalid");
            }
        }

        #region SharePoint methods

        public static void Createfolder(string accessToken, string sharePointSite, string library, string folder)
        {
            GetSpResponse(accessToken, $"{sharePointSite}/_api/lists/getByTitle('{library}')/rootfolder/folders/add(url ='{folder}')", "POST");
        }

        //public static string GetFolder(string accessToken, string sharePointSite, string library)
        //{
        //    // Query to get library
        //    return GetSpResponse(accessToken, $"{sharePointSite}/_api/lists/getByTitle('{library}')");
        //}

        public static string GetFolderContents(string accessToken, string sharePointSite, string library)
        {
            // Query to get library contents
            return GetSpResponse(accessToken, $"{sharePointSite}/_api/web/getFolderByServerRelativeUrl('{library}')/Files");
        }

        //public static string GetRootContents(string accessToken, string sharePointSite)
        //{
        //    return GetSpResponse(accessToken, $"{sharePointSite}/_api/site");
        //}

        private static string GetSpResponse(string accessToken, string uri, string method = "GET")
        {
            // Query to get library
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(uri);
            request.Method = method;
            request.Accept = "application/json;odata=verbose";
            request.Headers.Add(HttpRequestHeader.Authorization, "Bearer " + accessToken);
            request.ContentLength = 0;

            try
            {
                using (WebResponse response = request.GetResponse())
                {
                    // Do something if the resource has changed.
                    Console.WriteLine("Request successful.");
                    using (var streamReader = new StreamReader(response.GetResponseStream()))
                    {
                        var result = streamReader.ReadToEnd();
                        return result;
                    }
                }
            }
            catch (WebException wex)
            {
                HttpWebResponse httpResponse = wex.Response as HttpWebResponse;
                if (httpResponse.StatusCode == HttpStatusCode.NotModified)
                {
                    // resource was not modified.
                    Console.WriteLine($"Request failed.");
                }

                // Something else happened. Rethrow or log.
                Console.WriteLine($"Status code: {httpResponse.StatusCode}");
                throw;
            }
        }

        #endregion
        }
}
